package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnGateway(
    availabilityZone: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.VpnState] = Optional.Absent,
    `type`: Optional[zio.aws.ec2.model.GatewayType] = Optional.Absent,
    vpcAttachments: Optional[Iterable[zio.aws.ec2.model.VpcAttachment]] =
      Optional.Absent,
    vpnGatewayId: Optional[String] = Optional.Absent,
    amazonSideAsn: Optional[Long] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.VpnGateway = {
    import VpnGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpnGateway
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        vpcAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcAttachments)
      .optionallyWith(vpnGatewayId.map(value => value: java.lang.String))(
        _.vpnGatewayId
      )
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(
        _.amazonSideAsn
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnGateway.ReadOnly =
    zio.aws.ec2.model.VpnGateway.wrap(buildAwsValue())
}
object VpnGateway {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VpnGateway] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnGateway = zio.aws.ec2.model.VpnGateway(
      availabilityZone.map(value => value),
      state.map(value => value),
      `type`.map(value => value),
      vpcAttachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpnGatewayId.map(value => value),
      amazonSideAsn.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def availabilityZone: Optional[String]
    def state: Optional[zio.aws.ec2.model.VpnState]
    def `type`: Optional[zio.aws.ec2.model.GatewayType]
    def vpcAttachments: Optional[List[zio.aws.ec2.model.VpcAttachment.ReadOnly]]
    def vpnGatewayId: Optional[String]
    def amazonSideAsn: Optional[Long]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.VpnState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.GatewayType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcAttachments
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpcAttachment.ReadOnly]] =
      AwsError.unwrapOptionField("vpcAttachments", vpcAttachments)
    def getVpnGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getAmazonSideAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpnGateway
  ) extends zio.aws.ec2.model.VpnGateway.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.VpnState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.VpnState.wrap(value))
    override val `type`: Optional[zio.aws.ec2.model.GatewayType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ec2.model.GatewayType.wrap(value))
    override val vpcAttachments
        : Optional[List[zio.aws.ec2.model.VpcAttachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcAttachment.wrap(item)
          }.toList
        )
    override val vpnGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayId())
      .map(value => value: String)
    override val amazonSideAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => value: Long)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpnGateway
  ): zio.aws.ec2.model.VpnGateway.ReadOnly = new Wrapper(impl)
}
