package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThroughResourcesStatement(
    resourceStatement: Optional[zio.aws.ec2.model.ResourceStatement] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement = {
    import ThroughResourcesStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement
      .builder()
      .optionallyWith(resourceStatement.map(value => value.buildAwsValue()))(
        _.resourceStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly =
    zio.aws.ec2.model.ThroughResourcesStatement.wrap(buildAwsValue())
}
object ThroughResourcesStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ThroughResourcesStatement =
      zio.aws.ec2.model.ThroughResourcesStatement(
        resourceStatement.map(value => value.asEditable)
      )
    def resourceStatement
        : Optional[zio.aws.ec2.model.ResourceStatement.ReadOnly]
    def getResourceStatement
        : ZIO[Any, AwsError, zio.aws.ec2.model.ResourceStatement.ReadOnly] =
      AwsError.unwrapOptionField("resourceStatement", resourceStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement
  ) extends zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly {
    override val resourceStatement
        : Optional[zio.aws.ec2.model.ResourceStatement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceStatement())
        .map(value => zio.aws.ec2.model.ResourceStatement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ThroughResourcesStatement
  ): zio.aws.ec2.model.ThroughResourcesStatement.ReadOnly = new Wrapper(impl)
}
