package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendDiagnosticInterruptRequest(instanceId: InstanceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest = {
    import SendDiagnosticInterruptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SendDiagnosticInterruptRequest.ReadOnly =
    zio.aws.ec2.model.SendDiagnosticInterruptRequest.wrap(buildAwsValue())
}
object SendDiagnosticInterruptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SendDiagnosticInterruptRequest =
      zio.aws.ec2.model.SendDiagnosticInterruptRequest(instanceId)
    def instanceId: InstanceId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest
  ) extends zio.aws.ec2.model.SendDiagnosticInterruptRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SendDiagnosticInterruptRequest
  ): zio.aws.ec2.model.SendDiagnosticInterruptRequest.ReadOnly = new Wrapper(
    impl
  )
}
