package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SelfServicePortal {
  def unwrap: software.amazon.awssdk.services.ec2.model.SelfServicePortal
}
object SelfServicePortal {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SelfServicePortal
  ): zio.aws.ec2.model.SelfServicePortal = value match {
    case software.amazon.awssdk.services.ec2.model.SelfServicePortal.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SelfServicePortal.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.ec2.model.SelfServicePortal.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SelfServicePortal {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SelfServicePortal =
      software.amazon.awssdk.services.ec2.model.SelfServicePortal.UNKNOWN_TO_SDK_VERSION
  }
  case object enabled extends zio.aws.ec2.model.SelfServicePortal {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SelfServicePortal =
      software.amazon.awssdk.services.ec2.model.SelfServicePortal.ENABLED
  }
  case object disabled extends zio.aws.ec2.model.SelfServicePortal {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SelfServicePortal =
      software.amazon.awssdk.services.ec2.model.SelfServicePortal.DISABLED
  }
}
