package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityGroupRuleDescription(
    securityGroupRuleId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription = {
    import SecurityGroupRuleDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription
      .builder()
      .optionallyWith(
        securityGroupRuleId.map(value => value: java.lang.String)
      )(_.securityGroupRuleId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly =
    zio.aws.ec2.model.SecurityGroupRuleDescription.wrap(buildAwsValue())
}
object SecurityGroupRuleDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SecurityGroupRuleDescription =
      zio.aws.ec2.model.SecurityGroupRuleDescription(
        securityGroupRuleId.map(value => value),
        description.map(value => value)
      )
    def securityGroupRuleId: Optional[String]
    def description: Optional[String]
    def getSecurityGroupRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("securityGroupRuleId", securityGroupRuleId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription
  ) extends zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly {
    override val securityGroupRuleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroupRuleId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SecurityGroupRuleDescription
  ): zio.aws.ec2.model.SecurityGroupRuleDescription.ReadOnly = new Wrapper(impl)
}
