package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreManagedPrefixListVersionResponse(
    prefixList: Optional[zio.aws.ec2.model.ManagedPrefixList] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse = {
    import RestoreManagedPrefixListVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse
      .builder()
      .optionallyWith(prefixList.map(value => value.buildAwsValue()))(
        _.prefixList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly =
    zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse
      .wrap(buildAwsValue())
}
object RestoreManagedPrefixListVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse =
      zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse(
        prefixList.map(value => value.asEditable)
      )
    def prefixList: Optional[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]
    def getPrefixList
        : ZIO[Any, AwsError, zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      AwsError.unwrapOptionField("prefixList", prefixList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse
  ) extends zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly {
    override val prefixList
        : Optional[zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixList())
        .map(value => zio.aws.ec2.model.ManagedPrefixList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreManagedPrefixListVersionResponse
  ): zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly =
    new Wrapper(impl)
}
