package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PathStatementRequest(
    packetHeaderStatement: Optional[
      zio.aws.ec2.model.PacketHeaderStatementRequest
    ] = Optional.Absent,
    resourceStatement: Optional[zio.aws.ec2.model.ResourceStatementRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PathStatementRequest = {
    import PathStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PathStatementRequest
      .builder()
      .optionallyWith(
        packetHeaderStatement.map(value => value.buildAwsValue())
      )(_.packetHeaderStatement)
      .optionallyWith(resourceStatement.map(value => value.buildAwsValue()))(
        _.resourceStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PathStatementRequest.ReadOnly =
    zio.aws.ec2.model.PathStatementRequest.wrap(buildAwsValue())
}
object PathStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PathStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PathStatementRequest =
      zio.aws.ec2.model.PathStatementRequest(
        packetHeaderStatement.map(value => value.asEditable),
        resourceStatement.map(value => value.asEditable)
      )
    def packetHeaderStatement
        : Optional[zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly]
    def resourceStatement
        : Optional[zio.aws.ec2.model.ResourceStatementRequest.ReadOnly]
    def getPacketHeaderStatement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("packetHeaderStatement", packetHeaderStatement)
    def getResourceStatement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ResourceStatementRequest.ReadOnly
    ] = AwsError.unwrapOptionField("resourceStatement", resourceStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PathStatementRequest
  ) extends zio.aws.ec2.model.PathStatementRequest.ReadOnly {
    override val packetHeaderStatement
        : Optional[zio.aws.ec2.model.PacketHeaderStatementRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packetHeaderStatement())
        .map(value =>
          zio.aws.ec2.model.PacketHeaderStatementRequest.wrap(value)
        )
    override val resourceStatement
        : Optional[zio.aws.ec2.model.ResourceStatementRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceStatement())
        .map(value => zio.aws.ec2.model.ResourceStatementRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PathStatementRequest
  ): zio.aws.ec2.model.PathStatementRequest.ReadOnly = new Wrapper(impl)
}
