package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionOptionsResponse(
    vpnConnection: Optional[zio.aws.ec2.model.VpnConnection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse = {
    import ModifyVpnConnectionOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.wrap(buildAwsValue())
}
object ModifyVpnConnectionOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse =
      zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Optional[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ) extends zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly {
    override val vpnConnection
        : Optional[zio.aws.ec2.model.VpnConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnection())
        .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ): zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
