package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{IpamNetmaskLength, IpamPoolId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ModifyIpamPoolRequest(
    ipamPoolId: IpamPoolId,
    description: Optional[String] = Optional.Absent,
    autoImport: Optional[Boolean] = Optional.Absent,
    allocationMinNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationMaxNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      Optional.Absent,
    clearAllocationDefaultNetmaskLength: Optional[Boolean] = Optional.Absent,
    addAllocationResourceTags: Optional[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = Optional.Absent,
    removeAllocationResourceTags: Optional[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest = {
    import ModifyIpamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
      .builder()
      .ipamPoolId(IpamPoolId.unwrap(ipamPoolId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        clearAllocationDefaultNetmaskLength.map(value =>
          value: java.lang.Boolean
        )
      )(_.clearAllocationDefaultNetmaskLength)
      .optionallyWith(
        addAllocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addAllocationResourceTags)
      .optionallyWith(
        removeAllocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeAllocationResourceTags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIpamPoolRequest.wrap(buildAwsValue())
}
object ModifyIpamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamPoolRequest =
      zio.aws.ec2.model.ModifyIpamPoolRequest(
        ipamPoolId,
        description.map(value => value),
        autoImport.map(value => value),
        allocationMinNetmaskLength.map(value => value),
        allocationMaxNetmaskLength.map(value => value),
        allocationDefaultNetmaskLength.map(value => value),
        clearAllocationDefaultNetmaskLength.map(value => value),
        addAllocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeAllocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ipamPoolId: IpamPoolId
    def description: Optional[String]
    def autoImport: Optional[Boolean]
    def allocationMinNetmaskLength: Optional[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    def clearAllocationDefaultNetmaskLength: Optional[Boolean]
    def addAllocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def removeAllocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def getIpamPoolId: ZIO[Any, Nothing, IpamPoolId] = ZIO.succeed(ipamPoolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getClearAllocationDefaultNetmaskLength: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "clearAllocationDefaultNetmaskLength",
        clearAllocationDefaultNetmaskLength
      )
    def getAddAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "addAllocationResourceTags",
      addAllocationResourceTags
    )
    def getRemoveAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "removeAllocationResourceTags",
      removeAllocationResourceTags
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ) extends zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly {
    override val ipamPoolId: IpamPoolId =
      zio.aws.ec2.model.primitives.IpamPoolId(impl.ipamPoolId())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val autoImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoImport())
      .map(value => value: Boolean)
    override val allocationMinNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMinNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMaxNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val clearAllocationDefaultNetmaskLength: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clearAllocationDefaultNetmaskLength())
        .map(value => value: Boolean)
    override val addAllocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addAllocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
    override val removeAllocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeAllocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamPoolRequest
  ): zio.aws.ec2.model.ModifyIpamPoolRequest.ReadOnly = new Wrapper(impl)
}
