package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class InstanceStatusDetails(
    impairedSince: Optional[DateTime] = Optional.Absent,
    name: Optional[zio.aws.ec2.model.StatusName] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.StatusType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStatusDetails = {
    import InstanceStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStatusDetails
      .builder()
      .optionallyWith(
        impairedSince.map(value => DateTime.unwrap(value): Instant)
      )(_.impairedSince)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStatusDetails.ReadOnly =
    zio.aws.ec2.model.InstanceStatusDetails.wrap(buildAwsValue())
}
object InstanceStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStatusDetails =
      zio.aws.ec2.model.InstanceStatusDetails(
        impairedSince.map(value => value),
        name.map(value => value),
        status.map(value => value)
      )
    def impairedSince: Optional[DateTime]
    def name: Optional[zio.aws.ec2.model.StatusName]
    def status: Optional[zio.aws.ec2.model.StatusType]
    def getImpairedSince: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("impairedSince", impairedSince)
    def getName: ZIO[Any, AwsError, zio.aws.ec2.model.StatusName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusDetails
  ) extends zio.aws.ec2.model.InstanceStatusDetails.ReadOnly {
    override val impairedSince: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.impairedSince())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val name: Optional[zio.aws.ec2.model.StatusName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.ec2.model.StatusName.wrap(value))
    override val status: Optional[zio.aws.ec2.model.StatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.StatusType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatusDetails
  ): zio.aws.ec2.model.InstanceStatusDetails.ReadOnly = new Wrapper(impl)
}
