package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceHealthStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceHealthStatus
}
object InstanceHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceHealthStatus
  ): zio.aws.ec2.model.InstanceHealthStatus = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.HEALTHY =>
      val r = healthy
      r
    case software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.UNHEALTHY =>
      val r = unhealthy
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceHealthStatus =
      software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object healthy extends zio.aws.ec2.model.InstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceHealthStatus =
      software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.HEALTHY
  }
  case object unhealthy extends zio.aws.ec2.model.InstanceHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceHealthStatus =
      software.amazon.awssdk.services.ec2.model.InstanceHealthStatus.UNHEALTHY
  }
}
