package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DnsEntry(
    dnsName: Optional[String] = Optional.Absent,
    hostedZoneId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DnsEntry = {
    import DnsEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DnsEntry
      .builder()
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(hostedZoneId.map(value => value: java.lang.String))(
        _.hostedZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DnsEntry.ReadOnly =
    zio.aws.ec2.model.DnsEntry.wrap(buildAwsValue())
}
object DnsEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DnsEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DnsEntry = zio.aws.ec2.model
      .DnsEntry(dnsName.map(value => value), hostedZoneId.map(value => value))
    def dnsName: Optional[String]
    def hostedZoneId: Optional[String]
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHostedZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DnsEntry
  ) extends zio.aws.ec2.model.DnsEntry.ReadOnly {
    override val dnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => value: String)
    override val hostedZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DnsEntry
  ): zio.aws.ec2.model.DnsEntry.ReadOnly = new Wrapper(impl)
}
