package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateEnclaveCertificateIamRoleRequest(
    certificateArn: Optional[ResourceArn] = Optional.Absent,
    roleArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest = {
    import DisassociateEnclaveCertificateIamRoleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .builder()
      .optionallyWith(
        certificateArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        roleArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
      .wrap(buildAwsValue())
}
object DisassociateEnclaveCertificateIamRoleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest =
      zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest(
        certificateArn.map(value => value),
        roleArn.map(value => value)
      )
    def certificateArn: Optional[ResourceArn]
    def roleArn: Optional[ResourceArn]
    def getCertificateArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getRoleArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ) extends zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly {
    override val certificateArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val roleArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ): zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest.ReadOnly =
    new Wrapper(impl)
}
