package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointConnectionNotificationsResponse(
    connectionNotificationSet: Optional[
      Iterable[zio.aws.ec2.model.ConnectionNotification]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse = {
    import DescribeVpcEndpointConnectionNotificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse
      .builder()
      .optionallyWith(
        connectionNotificationSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connectionNotificationSet)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointConnectionNotificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse(
        connectionNotificationSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connectionNotificationSet
        : Optional[List[zio.aws.ec2.model.ConnectionNotification.ReadOnly]]
    def nextToken: Optional[String]
    def getConnectionNotificationSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ConnectionNotification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "connectionNotificationSet",
      connectionNotificationSet
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly {
    override val connectionNotificationSet
        : Optional[List[zio.aws.ec2.model.ConnectionNotification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionNotificationSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ConnectionNotification.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly =
    new Wrapper(impl)
}
