package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVolumeRequest(volumeId: VolumeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest = {
    import DeleteVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
      .builder()
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVolumeRequest.wrap(buildAwsValue())
}
object DeleteVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVolumeRequest =
      zio.aws.ec2.model.DeleteVolumeRequest(volumeId)
    def volumeId: VolumeId
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ) extends zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly {
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVolumeRequest
  ): zio.aws.ec2.model.DeleteVolumeRequest.ReadOnly = new Wrapper(impl)
}
