package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssignPrivateIpAddressesResponse(
    networkInterfaceId: Optional[String] = Optional.Absent,
    assignedPrivateIpAddresses: Optional[
      Iterable[zio.aws.ec2.model.AssignedPrivateIpAddress]
    ] = Optional.Absent,
    assignedIpv4Prefixes: Optional[
      Iterable[zio.aws.ec2.model.Ipv4PrefixSpecification]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse = {
    import AssignPrivateIpAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse
      .builder()
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(
        assignedPrivateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assignedPrivateIpAddresses)
      .optionallyWith(
        assignedIpv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assignedIpv4Prefixes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly =
    zio.aws.ec2.model.AssignPrivateIpAddressesResponse.wrap(buildAwsValue())
}
object AssignPrivateIpAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignPrivateIpAddressesResponse =
      zio.aws.ec2.model.AssignPrivateIpAddressesResponse(
        networkInterfaceId.map(value => value),
        assignedPrivateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assignedIpv4Prefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInterfaceId: Optional[String]
    def assignedPrivateIpAddresses
        : Optional[List[zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly]]
    def assignedIpv4Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]]
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getAssignedPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assignedPrivateIpAddresses",
      assignedPrivateIpAddresses
    )
    def getAssignedIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assignedIpv4Prefixes", assignedIpv4Prefixes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse
  ) extends zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly {
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val assignedPrivateIpAddresses
        : Optional[List[zio.aws.ec2.model.AssignedPrivateIpAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignedPrivateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AssignedPrivateIpAddress.wrap(item)
          }.toList
        )
    override val assignedIpv4Prefixes
        : Optional[List[zio.aws.ec2.model.Ipv4PrefixSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignedIpv4Prefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv4PrefixSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesResponse
  ): zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly = new Wrapper(
    impl
  )
}
