package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class SpotInstanceStatus(
    code: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent,
    updateTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotInstanceStatus = {
    import SpotInstanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(updateTime.map(value => DateTime.unwrap(value): Instant))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotInstanceStatus.ReadOnly =
    zio.aws.ec2.model.SpotInstanceStatus.wrap(buildAwsValue())
}
object SpotInstanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotInstanceStatus =
      zio.aws.ec2.model.SpotInstanceStatus(
        code.map(value => value),
        message.map(value => value),
        updateTime.map(value => value)
      )
    def code: Optional[String]
    def message: Optional[String]
    def updateTime: Optional[DateTime]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ) extends zio.aws.ec2.model.SpotInstanceStatus.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val updateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotInstanceStatus
  ): zio.aws.ec2.model.SpotInstanceStatus.ReadOnly = new Wrapper(impl)
}
