package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrefixListAssociation(
    resourceId: Optional[String] = Optional.Absent,
    resourceOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrefixListAssociation = {
    import PrefixListAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrefixListAssociation
      .builder()
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceOwner.map(value => value: java.lang.String))(
        _.resourceOwner
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrefixListAssociation.ReadOnly =
    zio.aws.ec2.model.PrefixListAssociation.wrap(buildAwsValue())
}
object PrefixListAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrefixListAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrefixListAssociation =
      zio.aws.ec2.model.PrefixListAssociation(
        resourceId.map(value => value),
        resourceOwner.map(value => value)
      )
    def resourceId: Optional[String]
    def resourceOwner: Optional[String]
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwner", resourceOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListAssociation
  ) extends zio.aws.ec2.model.PrefixListAssociation.ReadOnly {
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrefixListAssociation
  ): zio.aws.ec2.model.PrefixListAssociation.ReadOnly = new Wrapper(impl)
}
