package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessGroupPolicyResponse(
    policyEnabled: Optional[Boolean] = Optional.Absent,
    policyDocument: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse = {
    import ModifyVerifiedAccessGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse
      .builder()
      .optionallyWith(policyEnabled.map(value => value: java.lang.Boolean))(
        _.policyEnabled
      )
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse =
      zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse(
        policyEnabled.map(value => value),
        policyDocument.map(value => value)
      )
    def policyEnabled: Optional[Boolean]
    def policyDocument: Optional[String]
    def getPolicyEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("policyEnabled", policyEnabled)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse.ReadOnly {
    override val policyEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.policyEnabled())
      .map(value => value: Boolean)
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupPolicyResponse
  ): zio.aws.ec2.model.ModifyVerifiedAccessGroupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
