package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyPrivateDnsNameOptionsRequest(
    instanceId: Optional[InstanceId] = Optional.Absent,
    privateDnsHostnameType: Optional[zio.aws.ec2.model.HostnameType] =
      Optional.Absent,
    enableResourceNameDnsARecord: Optional[Boolean] = Optional.Absent,
    enableResourceNameDnsAAAARecord: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest = {
    import ModifyPrivateDnsNameOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(privateDnsHostnameType.map(value => value.unwrap))(
        _.privateDnsHostnameType
      )
      .optionallyWith(
        enableResourceNameDnsARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsARecord)
      .optionallyWith(
        enableResourceNameDnsAAAARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsAAAARecord)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest.wrap(buildAwsValue())
}
object ModifyPrivateDnsNameOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest =
      zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest(
        instanceId.map(value => value),
        privateDnsHostnameType.map(value => value),
        enableResourceNameDnsARecord.map(value => value),
        enableResourceNameDnsAAAARecord.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def privateDnsHostnameType: Optional[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecord: Optional[Boolean]
    def enableResourceNameDnsAAAARecord: Optional[Boolean]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPrivateDnsHostnameType
        : ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] = AwsError
      .unwrapOptionField("privateDnsHostnameType", privateDnsHostnameType)
    def getEnableResourceNameDnsARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecord",
        enableResourceNameDnsARecord
      )
    def getEnableResourceNameDnsAAAARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecord",
        enableResourceNameDnsAAAARecord
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest
  ) extends zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val privateDnsHostnameType
        : Optional[zio.aws.ec2.model.HostnameType] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsHostnameType())
      .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsARecord())
        .map(value => value: Boolean)
    override val enableResourceNameDnsAAAARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsAAAARecord())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyPrivateDnsNameOptionsRequest
  ): zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
