package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyImageAttributeRequest(
    attribute: Optional[String] = Optional.Absent,
    description: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    imageId: ImageId,
    launchPermission: Optional[
      zio.aws.ec2.model.LaunchPermissionModifications
    ] = Optional.Absent,
    operationType: Optional[zio.aws.ec2.model.OperationType] = Optional.Absent,
    productCodes: Optional[Iterable[String]] = Optional.Absent,
    userGroups: Optional[Iterable[String]] = Optional.Absent,
    userIds: Optional[Iterable[String]] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    organizationArns: Optional[Iterable[String]] = Optional.Absent,
    organizationalUnitArns: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest = {
    import ModifyImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
      .builder()
      .optionallyWith(attribute.map(value => value: java.lang.String))(
        _.attribute
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(launchPermission.map(value => value.buildAwsValue()))(
        _.launchPermission
      )
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        organizationArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationArns)
      .optionallyWith(
        organizationalUnitArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitArns)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyImageAttributeRequest.wrap(buildAwsValue())
}
object ModifyImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyImageAttributeRequest =
      zio.aws.ec2.model.ModifyImageAttributeRequest(
        attribute.map(value => value),
        description.map(value => value.asEditable),
        imageId,
        launchPermission.map(value => value.asEditable),
        operationType.map(value => value),
        productCodes.map(value => value),
        userGroups.map(value => value),
        userIds.map(value => value),
        value.map(value => value),
        organizationArns.map(value => value),
        organizationalUnitArns.map(value => value)
      )
    def attribute: Optional[String]
    def description: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def imageId: ImageId
    def launchPermission
        : Optional[zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly]
    def operationType: Optional[zio.aws.ec2.model.OperationType]
    def productCodes: Optional[List[String]]
    def userGroups: Optional[List[String]]
    def userIds: Optional[List[String]]
    def value: Optional[String]
    def organizationArns: Optional[List[String]]
    def organizationalUnitArns: Optional[List[String]]
    def getAttribute: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getLaunchPermission: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly
    ] = AwsError.unwrapOptionField("launchPermission", launchPermission)
    def getOperationType: ZIO[Any, AwsError, zio.aws.ec2.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getProductCodes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getUserGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userGroups", userGroups)
    def getUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getOrganizationArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("organizationArns", organizationArns)
    def getOrganizationalUnitArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("organizationalUnitArns", organizationalUnitArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ) extends zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly {
    override val attribute: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attribute())
      .map(value => value: String)
    override val description
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val launchPermission
        : Optional[zio.aws.ec2.model.LaunchPermissionModifications.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchPermission())
        .map(value =>
          zio.aws.ec2.model.LaunchPermissionModifications.wrap(value)
        )
    override val operationType: Optional[zio.aws.ec2.model.OperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationType())
        .map(value => zio.aws.ec2.model.OperationType.wrap(value))
    override val productCodes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val userIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val organizationArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val organizationalUnitArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest
  ): zio.aws.ec2.model.ModifyImageAttributeRequest.ReadOnly = new Wrapper(impl)
}
