package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMonitoring(
    instanceId: Optional[String] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.Monitoring] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceMonitoring = {
    import InstanceMonitoring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceMonitoring
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceMonitoring.ReadOnly =
    zio.aws.ec2.model.InstanceMonitoring.wrap(buildAwsValue())
}
object InstanceMonitoring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceMonitoring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceMonitoring =
      zio.aws.ec2.model.InstanceMonitoring(
        instanceId.map(value => value),
        monitoring.map(value => value.asEditable)
      )
    def instanceId: Optional[String]
    def monitoring: Optional[zio.aws.ec2.model.Monitoring.ReadOnly]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getMonitoring
        : ZIO[Any, AwsError, zio.aws.ec2.model.Monitoring.ReadOnly] =
      AwsError.unwrapOptionField("monitoring", monitoring)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMonitoring
  ) extends zio.aws.ec2.model.InstanceMonitoring.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val monitoring: Optional[zio.aws.ec2.model.Monitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value => zio.aws.ec2.model.Monitoring.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMonitoring
  ): zio.aws.ec2.model.InstanceMonitoring.ReadOnly = new Wrapper(impl)
}
