package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowStateChange(
    instanceEventWindowId: Optional[InstanceEventWindowId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.InstanceEventWindowState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange = {
    import InstanceEventWindowStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
      .builder()
      .optionallyWith(
        instanceEventWindowId.map(value =>
          InstanceEventWindowId.unwrap(value): java.lang.String
        )
      )(_.instanceEventWindowId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowStateChange.wrap(buildAwsValue())
}
object InstanceEventWindowStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowStateChange =
      zio.aws.ec2.model.InstanceEventWindowStateChange(
        instanceEventWindowId.map(value => value),
        state.map(value => value)
      )
    def instanceEventWindowId: Optional[InstanceEventWindowId]
    def state: Optional[zio.aws.ec2.model.InstanceEventWindowState]
    def getInstanceEventWindowId: ZIO[Any, AwsError, InstanceEventWindowId] =
      AwsError.unwrapOptionField("instanceEventWindowId", instanceEventWindowId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindowState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ) extends zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly {
    override val instanceEventWindowId: Optional[InstanceEventWindowId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceEventWindowId())
        .map(value => zio.aws.ec2.model.primitives.InstanceEventWindowId(value))
    override val state: Optional[zio.aws.ec2.model.InstanceEventWindowState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.InstanceEventWindowState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ): zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly = new Wrapper(
    impl
  )
}
