package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVerifiedAccessGroupPolicyRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest = {
    import GetVerifiedAccessGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly =
    zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.wrap(buildAwsValue())
}
object GetVerifiedAccessGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest =
      zio.aws.ec2.model
        .GetVerifiedAccessGroupPolicyRequest(verifiedAccessGroupId)
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ) extends zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessGroupPolicyRequest
  ): zio.aws.ec2.model.GetVerifiedAccessGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
