package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetIpamPoolCidrsResponse(
    ipamPoolCidrs: Optional[Iterable[zio.aws.ec2.model.IpamPoolCidr]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse = {
    import GetIpamPoolCidrsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse
      .builder()
      .optionallyWith(
        ipamPoolCidrs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamPoolCidrs)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly =
    zio.aws.ec2.model.GetIpamPoolCidrsResponse.wrap(buildAwsValue())
}
object GetIpamPoolCidrsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetIpamPoolCidrsResponse =
      zio.aws.ec2.model.GetIpamPoolCidrsResponse(
        ipamPoolCidrs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipamPoolCidrs: Optional[List[zio.aws.ec2.model.IpamPoolCidr.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getIpamPoolCidrs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamPoolCidr.ReadOnly]] =
      AwsError.unwrapOptionField("ipamPoolCidrs", ipamPoolCidrs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse
  ) extends zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly {
    override val ipamPoolCidrs
        : Optional[List[zio.aws.ec2.model.IpamPoolCidr.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPoolCidrs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamPoolCidr.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetIpamPoolCidrsResponse
  ): zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly = new Wrapper(impl)
}
