package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait EnaSupport {
  def unwrap: software.amazon.awssdk.services.ec2.model.EnaSupport
}
object EnaSupport {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.EnaSupport
  ): zio.aws.ec2.model.EnaSupport = value match {
    case software.amazon.awssdk.services.ec2.model.EnaSupport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.EnaSupport.UNSUPPORTED =>
      val r = unsupported
      r
    case software.amazon.awssdk.services.ec2.model.EnaSupport.SUPPORTED =>
      val r = supported
      r
    case software.amazon.awssdk.services.ec2.model.EnaSupport.REQUIRED =>
      val r = required
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.EnaSupport {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EnaSupport =
      software.amazon.awssdk.services.ec2.model.EnaSupport.UNKNOWN_TO_SDK_VERSION
  }
  case object unsupported extends zio.aws.ec2.model.EnaSupport {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EnaSupport =
      software.amazon.awssdk.services.ec2.model.EnaSupport.UNSUPPORTED
  }
  case object supported extends zio.aws.ec2.model.EnaSupport {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EnaSupport =
      software.amazon.awssdk.services.ec2.model.EnaSupport.SUPPORTED
  }
  case object required extends zio.aws.ec2.model.EnaSupport {
    override def unwrap: software.amazon.awssdk.services.ec2.model.EnaSupport =
      software.amazon.awssdk.services.ec2.model.EnaSupport.REQUIRED
  }
}
