package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DiskImageFormat {
  def unwrap: software.amazon.awssdk.services.ec2.model.DiskImageFormat
}
object DiskImageFormat {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DiskImageFormat
  ): zio.aws.ec2.model.DiskImageFormat = value match {
    case software.amazon.awssdk.services.ec2.model.DiskImageFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DiskImageFormat.VMDK =>
      val r = VMDK
      r
    case software.amazon.awssdk.services.ec2.model.DiskImageFormat.RAW =>
      val r = RAW
      r
    case software.amazon.awssdk.services.ec2.model.DiskImageFormat.VHD =>
      val r = VHD
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DiskImageFormat =
      software.amazon.awssdk.services.ec2.model.DiskImageFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object VMDK extends zio.aws.ec2.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DiskImageFormat =
      software.amazon.awssdk.services.ec2.model.DiskImageFormat.VMDK
  }
  case object RAW extends zio.aws.ec2.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DiskImageFormat =
      software.amazon.awssdk.services.ec2.model.DiskImageFormat.RAW
  }
  case object VHD extends zio.aws.ec2.model.DiskImageFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DiskImageFormat =
      software.amazon.awssdk.services.ec2.model.DiskImageFormat.VHD
  }
}
