package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DirectoryServiceAuthenticationRequest(
    directoryId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest = {
    import DirectoryServiceAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest
      .builder()
      .optionallyWith(directoryId.map(value => value: java.lang.String))(
        _.directoryId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly =
    zio.aws.ec2.model.DirectoryServiceAuthenticationRequest
      .wrap(buildAwsValue())
}
object DirectoryServiceAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DirectoryServiceAuthenticationRequest =
      zio.aws.ec2.model
        .DirectoryServiceAuthenticationRequest(directoryId.map(value => value))
    def directoryId: Optional[String]
    def getDirectoryId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("directoryId", directoryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest
  ) extends zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly {
    override val directoryId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DirectoryServiceAuthenticationRequest
  ): zio.aws.ec2.model.DirectoryServiceAuthenticationRequest.ReadOnly =
    new Wrapper(impl)
}
