package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSubnetsResponse(
    subnets: Optional[Iterable[zio.aws.ec2.model.Subnet]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse = {
    import DescribeSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse
      .builder()
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeSubnetsResponse.wrap(buildAwsValue())
}
object DescribeSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSubnetsResponse =
      zio.aws.ec2.model.DescribeSubnetsResponse(
        subnets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def subnets: Optional[List[zio.aws.ec2.model.Subnet.ReadOnly]]
    def nextToken: Optional[String]
    def getSubnets
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Subnet.ReadOnly]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse
  ) extends zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly {
    override val subnets: Optional[List[zio.aws.ec2.model.Subnet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Subnet.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse
  ): zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly = new Wrapper(impl)
}
