package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfaceAttributeResponse(
    attachment: Optional[zio.aws.ec2.model.NetworkInterfaceAttachment] =
      Optional.Absent,
    description: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    groups: Optional[Iterable[zio.aws.ec2.model.GroupIdentifier]] =
      Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    sourceDestCheck: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse = {
    import DescribeNetworkInterfaceAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInterfaceAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse =
      zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse(
        attachment.map(value => value.asEditable),
        description.map(value => value.asEditable),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceId.map(value => value),
        sourceDestCheck.map(value => value.asEditable)
      )
    def attachment
        : Optional[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly]
    def description: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def groups: Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def networkInterfaceId: Optional[String]
    def sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly {
    override val attachment
        : Optional[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.ec2.model.NetworkInterfaceAttachment.wrap(value))
    override val description
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val groups
        : Optional[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.GroupIdentifier.wrap(item)
          }.toList
        )
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDestCheck())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ): zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
