package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAccessScopeAnalysesResponse(
    networkInsightsAccessScopeAnalyses: Optional[
      Iterable[zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse = {
    import DescribeNetworkInsightsAccessScopeAnalysesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalyses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInsightsAccessScopeAnalyses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAccessScopeAnalysesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse =
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse(
        networkInsightsAccessScopeAnalyses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeAnalyses: Optional[
      List[zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getNetworkInsightsAccessScopeAnalyses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopeAnalyses",
      networkInsightsAccessScopeAnalyses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly {
    override val networkInsightsAccessScopeAnalyses: Optional[
      List[zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalyses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse
  ): zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly =
    new Wrapper(impl)
}
