package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteTableResponse(
    transitGatewayRouteTable: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTable
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse = {
    import DeleteTransitGatewayRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTable.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTable)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse =
      zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse(
        transitGatewayRouteTable.map(value => value.asEditable)
      )
    def transitGatewayRouteTable
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly]
    def getTransitGatewayRouteTable: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTable",
      transitGatewayRouteTable
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly {
    override val transitGatewayRouteTable
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTable())
        .map(value => zio.aws.ec2.model.TransitGatewayRouteTable.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly =
    new Wrapper(impl)
}
