package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayConnectResponse(
    transitGatewayConnect: Optional[zio.aws.ec2.model.TransitGatewayConnect] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse = {
    import DeleteTransitGatewayConnectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse
      .builder()
      .optionallyWith(
        transitGatewayConnect.map(value => value.buildAwsValue())
      )(_.transitGatewayConnect)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.wrap(buildAwsValue())
}
object DeleteTransitGatewayConnectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayConnectResponse =
      zio.aws.ec2.model.DeleteTransitGatewayConnectResponse(
        transitGatewayConnect.map(value => value.asEditable)
      )
    def transitGatewayConnect
        : Optional[zio.aws.ec2.model.TransitGatewayConnect.ReadOnly]
    def getTransitGatewayConnect
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayConnect.ReadOnly] =
      AwsError.unwrapOptionField("transitGatewayConnect", transitGatewayConnect)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly {
    override val transitGatewayConnect
        : Optional[zio.aws.ec2.model.TransitGatewayConnect.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayConnect())
        .map(value => zio.aws.ec2.model.TransitGatewayConnect.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayConnectResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly =
    new Wrapper(impl)
}
