package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAccessScopeAnalysisResponse(
    networkInsightsAccessScopeAnalysisId: Optional[
      NetworkInsightsAccessScopeAnalysisId
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse = {
    import DeleteNetworkInsightsAccessScopeAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisId.map(value =>
          NetworkInsightsAccessScopeAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse
      .wrap(buildAwsValue())
}
object DeleteNetworkInsightsAccessScopeAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse =
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse(
        networkInsightsAccessScopeAnalysisId.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeAnalysisId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisId",
        networkInsightsAccessScopeAnalysisId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse
  ): zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
