package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkAclId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNetworkAclRequest(networkAclId: NetworkAclId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest = {
    import DeleteNetworkAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
      .builder()
      .networkAclId(NetworkAclId.unwrap(networkAclId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkAclRequest.wrap(buildAwsValue())
}
object DeleteNetworkAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkAclRequest =
      zio.aws.ec2.model.DeleteNetworkAclRequest(networkAclId)
    def networkAclId: NetworkAclId
    def getNetworkAclId: ZIO[Any, Nothing, NetworkAclId] =
      ZIO.succeed(networkAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ) extends zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly {
    override val networkAclId: NetworkAclId =
      zio.aws.ec2.model.primitives.NetworkAclId(impl.networkAclId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkAclRequest
  ): zio.aws.ec2.model.DeleteNetworkAclRequest.ReadOnly = new Wrapper(impl)
}
