package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCoipPoolResponse(
    coipPool: Optional[zio.aws.ec2.model.CoipPool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse = {
    import CreateCoipPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse
      .builder()
      .optionallyWith(coipPool.map(value => value.buildAwsValue()))(_.coipPool)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCoipPoolResponse.ReadOnly =
    zio.aws.ec2.model.CreateCoipPoolResponse.wrap(buildAwsValue())
}
object CreateCoipPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCoipPoolResponse = zio.aws.ec2.model
      .CreateCoipPoolResponse(coipPool.map(value => value.asEditable))
    def coipPool: Optional[zio.aws.ec2.model.CoipPool.ReadOnly]
    def getCoipPool: ZIO[Any, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly] =
      AwsError.unwrapOptionField("coipPool", coipPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse
  ) extends zio.aws.ec2.model.CreateCoipPoolResponse.ReadOnly {
    override val coipPool: Optional[zio.aws.ec2.model.CoipPool.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipPool())
        .map(value => zio.aws.ec2.model.CoipPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipPoolResponse
  ): zio.aws.ec2.model.CreateCoipPoolResponse.ReadOnly = new Wrapper(impl)
}
