package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, ClientVpnEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClientVpnRouteRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    destinationCidrBlock: String,
    targetVpcSubnetId: SubnetId,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest = {
    import CreateClientVpnRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .targetVpcSubnetId(SubnetId.unwrap(targetVpcSubnetId): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateClientVpnRouteRequest.ReadOnly =
    zio.aws.ec2.model.CreateClientVpnRouteRequest.wrap(buildAwsValue())
}
object CreateClientVpnRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateClientVpnRouteRequest =
      zio.aws.ec2.model.CreateClientVpnRouteRequest(
        clientVpnEndpointId,
        destinationCidrBlock,
        targetVpcSubnetId,
        description.map(value => value),
        clientToken.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def destinationCidrBlock: String
    def targetVpcSubnetId: SubnetId
    def description: Optional[String]
    def clientToken: Optional[String]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getTargetVpcSubnetId: ZIO[Any, Nothing, SubnetId] =
      ZIO.succeed(targetVpcSubnetId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest
  ) extends zio.aws.ec2.model.CreateClientVpnRouteRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val targetVpcSubnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.targetVpcSubnetId())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateClientVpnRouteRequest
  ): zio.aws.ec2.model.CreateClientVpnRouteRequest.ReadOnly = new Wrapper(impl)
}
