package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ClientVpnConnectionStatusCode {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode
}
object ClientVpnConnectionStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode
  ): zio.aws.ec2.model.ClientVpnConnectionStatusCode = value match {
    case software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.FAILED_TO_TERMINATE =>
      val r = `failed-to-terminate`
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.TERMINATING =>
      val r = terminating
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.TERMINATED =>
      val r = terminated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ClientVpnConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.ClientVpnConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.ACTIVE
  }
  case object `failed-to-terminate`
      extends zio.aws.ec2.model.ClientVpnConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.FAILED_TO_TERMINATE
  }
  case object terminating
      extends zio.aws.ec2.model.ClientVpnConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.TERMINATING
  }
  case object terminated
      extends zio.aws.ec2.model.ClientVpnConnectionStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnConnectionStatusCode.TERMINATED
  }
}
