package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachNetworkInterfaceResponse(
    attachmentId: Optional[String] = Optional.Absent,
    networkCardIndex: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse = {
    import AttachNetworkInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
      .builder()
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly =
    zio.aws.ec2.model.AttachNetworkInterfaceResponse.wrap(buildAwsValue())
}
object AttachNetworkInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachNetworkInterfaceResponse =
      zio.aws.ec2.model.AttachNetworkInterfaceResponse(
        attachmentId.map(value => value),
        networkCardIndex.map(value => value)
      )
    def attachmentId: Optional[String]
    def networkCardIndex: Optional[Integer]
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ) extends zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly {
    override val attachmentId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentId())
      .map(value => value: String)
    override val networkCardIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkCardIndex())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ): zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
