package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AcceptTransitGatewayPeeringAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest = {
    import AcceptTransitGatewayPeeringAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
      .wrap(buildAwsValue())
}
object AcceptTransitGatewayPeeringAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest =
      zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest(
        transitGatewayAttachmentId
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ) extends zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ): zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
