package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeStatusDetails(
    name: Optional[zio.aws.ec2.model.VolumeStatusName] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusDetails = {
    import VolumeStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusDetails
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusDetails.ReadOnly =
    zio.aws.ec2.model.VolumeStatusDetails.wrap(buildAwsValue())
}
object VolumeStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusDetails = zio.aws.ec2.model
      .VolumeStatusDetails(name.map(value => value), status.map(value => value))
    def name: Optional[zio.aws.ec2.model.VolumeStatusName]
    def status: Optional[String]
    def getName: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeStatusName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusDetails
  ) extends zio.aws.ec2.model.VolumeStatusDetails.ReadOnly {
    override val name: Optional[zio.aws.ec2.model.VolumeStatusName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.ec2.model.VolumeStatusName.wrap(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusDetails
  ): zio.aws.ec2.model.VolumeStatusDetails.ReadOnly = new Wrapper(impl)
}
