package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserIdGroupPair(
    description: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent,
    peeringStatus: Optional[String] = Optional.Absent,
    userId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    vpcPeeringConnectionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UserIdGroupPair = {
    import UserIdGroupPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UserIdGroupPair
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(peeringStatus.map(value => value: java.lang.String))(
        _.peeringStatus
      )
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcPeeringConnectionId.map(value => value: java.lang.String)
      )(_.vpcPeeringConnectionId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UserIdGroupPair.ReadOnly =
    zio.aws.ec2.model.UserIdGroupPair.wrap(buildAwsValue())
}
object UserIdGroupPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UserIdGroupPair =
      zio.aws.ec2.model.UserIdGroupPair(
        description.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        peeringStatus.map(value => value),
        userId.map(value => value),
        vpcId.map(value => value),
        vpcPeeringConnectionId.map(value => value)
      )
    def description: Optional[String]
    def groupId: Optional[String]
    def groupName: Optional[String]
    def peeringStatus: Optional[String]
    def userId: Optional[String]
    def vpcId: Optional[String]
    def vpcPeeringConnectionId: Optional[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getPeeringStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peeringStatus", peeringStatus)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpcPeeringConnectionId", vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ) extends zio.aws.ec2.model.UserIdGroupPair.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val peeringStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.peeringStatus())
      .map(value => value: String)
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcPeeringConnectionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UserIdGroupPair
  ): zio.aws.ec2.model.UserIdGroupPair.ReadOnly = new Wrapper(impl)
}
