package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, TrunkInterfaceAssociationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrunkInterfaceAssociation(
    associationId: Optional[TrunkInterfaceAssociationId] = Optional.Absent,
    branchInterfaceId: Optional[String] = Optional.Absent,
    trunkInterfaceId: Optional[String] = Optional.Absent,
    interfaceProtocol: Optional[zio.aws.ec2.model.InterfaceProtocolType] =
      Optional.Absent,
    vlanId: Optional[Integer] = Optional.Absent,
    greKey: Optional[Integer] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation = {
    import TrunkInterfaceAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation
      .builder()
      .optionallyWith(
        associationId.map(value =>
          TrunkInterfaceAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(branchInterfaceId.map(value => value: java.lang.String))(
        _.branchInterfaceId
      )
      .optionallyWith(trunkInterfaceId.map(value => value: java.lang.String))(
        _.trunkInterfaceId
      )
      .optionallyWith(interfaceProtocol.map(value => value.unwrap))(
        _.interfaceProtocol
      )
      .optionallyWith(vlanId.map(value => value: java.lang.Integer))(_.vlanId)
      .optionallyWith(greKey.map(value => value: java.lang.Integer))(_.greKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly =
    zio.aws.ec2.model.TrunkInterfaceAssociation.wrap(buildAwsValue())
}
object TrunkInterfaceAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrunkInterfaceAssociation =
      zio.aws.ec2.model.TrunkInterfaceAssociation(
        associationId.map(value => value),
        branchInterfaceId.map(value => value),
        trunkInterfaceId.map(value => value),
        interfaceProtocol.map(value => value),
        vlanId.map(value => value),
        greKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associationId: Optional[TrunkInterfaceAssociationId]
    def branchInterfaceId: Optional[String]
    def trunkInterfaceId: Optional[String]
    def interfaceProtocol: Optional[zio.aws.ec2.model.InterfaceProtocolType]
    def vlanId: Optional[Integer]
    def greKey: Optional[Integer]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAssociationId: ZIO[Any, AwsError, TrunkInterfaceAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getBranchInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("branchInterfaceId", branchInterfaceId)
    def getTrunkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trunkInterfaceId", trunkInterfaceId)
    def getInterfaceProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.InterfaceProtocolType] =
      AwsError.unwrapOptionField("interfaceProtocol", interfaceProtocol)
    def getVlanId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vlanId", vlanId)
    def getGreKey: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("greKey", greKey)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation
  ) extends zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly {
    override val associationId: Optional[TrunkInterfaceAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ec2.model.primitives.TrunkInterfaceAssociationId(value)
        )
    override val branchInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.branchInterfaceId())
      .map(value => value: String)
    override val trunkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trunkInterfaceId())
      .map(value => value: String)
    override val interfaceProtocol
        : Optional[zio.aws.ec2.model.InterfaceProtocolType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interfaceProtocol())
        .map(value => zio.aws.ec2.model.InterfaceProtocolType.wrap(value))
    override val vlanId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vlanId())
      .map(value => value: Integer)
    override val greKey: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.greKey())
      .map(value => value: Integer)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrunkInterfaceAssociation
  ): zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly = new Wrapper(impl)
}
