package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  DateTime,
  TransitGatewayId,
  TransitGatewayAttachmentId
}
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnect(
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    transportTransitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    options: Optional[zio.aws.ec2.model.TransitGatewayConnectOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnect = {
    import TransitGatewayConnect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        transportTransitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transportTransitGatewayAttachmentId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayConnect.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnect.wrap(buildAwsValue())
}
object TransitGatewayConnect {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnect =
      zio.aws.ec2.model.TransitGatewayConnect(
        transitGatewayAttachmentId.map(value => value),
        transportTransitGatewayAttachmentId.map(value => value),
        transitGatewayId.map(value => value),
        state.map(value => value),
        creationTime.map(value => value),
        options.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def transportTransitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId]
    def transitGatewayId: Optional[TransitGatewayId]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def creationTime: Optional[DateTime]
    def options
        : Optional[zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransportTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transportTransitGatewayAttachmentId",
        transportTransitGatewayAttachmentId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ) extends zio.aws.ec2.model.TransitGatewayConnect.ReadOnly {
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transportTransitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transportTransitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value)
        )
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val options
        : Optional[zio.aws.ec2.model.TransitGatewayConnectOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayConnectOptions.wrap(value)
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnect
  ): zio.aws.ec2.model.TransitGatewayConnect.ReadOnly = new Wrapper(impl)
}
