package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayAttachmentState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState
}
object TransitGatewayAttachmentState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState
  ): zio.aws.ec2.model.TransitGatewayAttachmentState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.INITIATING =>
      val r = initiating
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.INITIATING_REQUEST =>
      val r = initiatingRequest
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.PENDING_ACCEPTANCE =>
      val r = pendingAcceptance
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.ROLLING_BACK =>
      val r = rollingBack
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.MODIFYING =>
      val r = modifying
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.DELETED =>
      val r = deleted
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.REJECTED =>
      val r = rejected
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.REJECTING =>
      val r = rejecting
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.FAILING =>
      val r = failing
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object initiating
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.INITIATING
  }
  case object initiatingRequest
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.INITIATING_REQUEST
  }
  case object pendingAcceptance
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.PENDING_ACCEPTANCE
  }
  case object rollingBack
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.ROLLING_BACK
  }
  case object pending extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.PENDING
  }
  case object available
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.AVAILABLE
  }
  case object modifying
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.MODIFYING
  }
  case object deleting extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.DELETING
  }
  case object deleted extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.DELETED
  }
  case object failed extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.FAILED
  }
  case object rejected extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.REJECTED
  }
  case object rejecting
      extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.REJECTING
  }
  case object failing extends zio.aws.ec2.model.TransitGatewayAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentState.FAILING
  }
}
