package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkInterfaceId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyNetworkInterfaceAttributeRequest(
    attachment: Optional[zio.aws.ec2.model.NetworkInterfaceAttachmentChanges] =
      Optional.Absent,
    description: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    groups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    networkInterfaceId: NetworkInterfaceId,
    sourceDestCheck: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    enaSrdSpecification: Optional[zio.aws.ec2.model.EnaSrdSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest = {
    import ModifyNetworkInterfaceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .optionallyWith(enaSrdSpecification.map(value => value.buildAwsValue()))(
        _.enaSrdSpecification
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest
      .wrap(buildAwsValue())
}
object ModifyNetworkInterfaceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest =
      zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest(
        attachment.map(value => value.asEditable),
        description.map(value => value.asEditable),
        groups.map(value => value),
        networkInterfaceId,
        sourceDestCheck.map(value => value.asEditable),
        enaSrdSpecification.map(value => value.asEditable)
      )
    def attachment
        : Optional[zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly]
    def description: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def groups: Optional[List[SecurityGroupId]]
    def networkInterfaceId: NetworkInterfaceId
    def sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enaSrdSpecification
        : Optional[zio.aws.ec2.model.EnaSrdSpecification.ReadOnly]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getEnaSrdSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnaSrdSpecification.ReadOnly] =
      AwsError.unwrapOptionField("enaSrdSpecification", enaSrdSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ) extends zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly {
    override val attachment: Optional[
      zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachment())
      .map(value =>
        zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.wrap(value)
      )
    override val description
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val groups: Optional[List[SecurityGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDestCheck())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enaSrdSpecification
        : Optional[zio.aws.ec2.model.EnaSrdSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSrdSpecification())
        .map(value => zio.aws.ec2.model.EnaSrdSpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ): zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
