package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateBlockDeviceMapping(
    deviceName: Optional[String] = Optional.Absent,
    virtualName: Optional[String] = Optional.Absent,
    ebs: Optional[zio.aws.ec2.model.LaunchTemplateEbsBlockDevice] =
      Optional.Absent,
    noDevice: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping = {
    import LaunchTemplateBlockDeviceMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping
      .builder()
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(virtualName.map(value => value: java.lang.String))(
        _.virtualName
      )
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(noDevice.map(value => value: java.lang.String))(
        _.noDevice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.wrap(buildAwsValue())
}
object LaunchTemplateBlockDeviceMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping =
      zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping(
        deviceName.map(value => value),
        virtualName.map(value => value),
        ebs.map(value => value.asEditable),
        noDevice.map(value => value)
      )
    def deviceName: Optional[String]
    def virtualName: Optional[String]
    def ebs: Optional[zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly]
    def noDevice: Optional[String]
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getVirtualName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("virtualName", virtualName)
    def getEbs: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly
    ] = AwsError.unwrapOptionField("ebs", ebs)
    def getNoDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("noDevice", noDevice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping
  ) extends zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly {
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val virtualName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualName())
      .map(value => value: String)
    override val ebs
        : Optional[zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebs())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.wrap(value)
        )
    override val noDevice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.noDevice())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping
  ): zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly = new Wrapper(
    impl
  )
}
