package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVpnConnectionDeviceTypesResponse(
    vpnConnectionDeviceTypes: Optional[
      Iterable[zio.aws.ec2.model.VpnConnectionDeviceType]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse = {
    import GetVpnConnectionDeviceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse
      .builder()
      .optionallyWith(
        vpnConnectionDeviceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpnConnectionDeviceTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly =
    zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.wrap(buildAwsValue())
}
object GetVpnConnectionDeviceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse =
      zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse(
        vpnConnectionDeviceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpnConnectionDeviceTypes
        : Optional[List[zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVpnConnectionDeviceTypes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpnConnectionDeviceTypes",
      vpnConnectionDeviceTypes
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse
  ) extends zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly {
    override val vpnConnectionDeviceTypes
        : Optional[List[zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnectionDeviceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpnConnectionDeviceType.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVpnConnectionDeviceTypesResponse
  ): zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
