package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnaSrdSpecification(
    enaSrdEnabled: Optional[Boolean] = Optional.Absent,
    enaSrdUdpSpecification: Optional[zio.aws.ec2.model.EnaSrdUdpSpecification] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnaSrdSpecification = {
    import EnaSrdSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnaSrdSpecification
      .builder()
      .optionallyWith(enaSrdEnabled.map(value => value: java.lang.Boolean))(
        _.enaSrdEnabled
      )
      .optionallyWith(
        enaSrdUdpSpecification.map(value => value.buildAwsValue())
      )(_.enaSrdUdpSpecification)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnaSrdSpecification.ReadOnly =
    zio.aws.ec2.model.EnaSrdSpecification.wrap(buildAwsValue())
}
object EnaSrdSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnaSrdSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnaSrdSpecification =
      zio.aws.ec2.model.EnaSrdSpecification(
        enaSrdEnabled.map(value => value),
        enaSrdUdpSpecification.map(value => value.asEditable)
      )
    def enaSrdEnabled: Optional[Boolean]
    def enaSrdUdpSpecification
        : Optional[zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly]
    def getEnaSrdEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSrdEnabled", enaSrdEnabled)
    def getEnaSrdUdpSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "enaSrdUdpSpecification",
      enaSrdUdpSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnaSrdSpecification
  ) extends zio.aws.ec2.model.EnaSrdSpecification.ReadOnly {
    override val enaSrdEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSrdEnabled())
      .map(value => value: Boolean)
    override val enaSrdUdpSpecification
        : Optional[zio.aws.ec2.model.EnaSrdUdpSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSrdUdpSpecification())
        .map(value => zio.aws.ec2.model.EnaSrdUdpSpecification.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnaSrdSpecification
  ): zio.aws.ec2.model.EnaSrdSpecification.ReadOnly = new Wrapper(impl)
}
