package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FpgaImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeFpgaImageAttributeRequest(
    fpgaImageId: FpgaImageId,
    attribute: zio.aws.ec2.model.FpgaImageAttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest = {
    import DescribeFpgaImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest
      .builder()
      .fpgaImageId(FpgaImageId.unwrap(fpgaImageId): java.lang.String)
      .attribute(attribute.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFpgaImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFpgaImageAttributeRequest.wrap(buildAwsValue())
}
object DescribeFpgaImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFpgaImageAttributeRequest =
      zio.aws.ec2.model
        .DescribeFpgaImageAttributeRequest(fpgaImageId, attribute)
    def fpgaImageId: FpgaImageId
    def attribute: zio.aws.ec2.model.FpgaImageAttributeName
    def getFpgaImageId: ZIO[Any, Nothing, FpgaImageId] =
      ZIO.succeed(fpgaImageId)
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.FpgaImageAttributeName] =
      ZIO.succeed(attribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest
  ) extends zio.aws.ec2.model.DescribeFpgaImageAttributeRequest.ReadOnly {
    override val fpgaImageId: FpgaImageId =
      zio.aws.ec2.model.primitives.FpgaImageId(impl.fpgaImageId())
    override val attribute: zio.aws.ec2.model.FpgaImageAttributeName =
      zio.aws.ec2.model.FpgaImageAttributeName.wrap(impl.attribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeRequest
  ): zio.aws.ec2.model.DescribeFpgaImageAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
